#include "AudioStack/SMT/clSrcState_RampDownToPause.h"
#include "AudioStack/clAudioSource.h"
#include "AudioStack/SMT/clSrcStateFactory.h"

namespace AudioStack
{

void clSrcState_RampDownToPause::vEnter(clAudioSource* pclAudioSource, tU32 , tU8 )
{
   if (NULL != pclAudioSource)
   {
      // invoke command on MW-interface
      pclAudioSource->vMW_Pause(pclAudioSource->u8GetNextSource());
   }
}

void clSrcState_RampDownToPause::vMsg_PauseDone(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreatePause(), u32UserData);
}

void clSrcState_RampDownToPause::vMsg_On(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // sequence is:
   // 1) init() -> init_done()
   // 2) on() -> requesConfirmed() -> on_done()
   // as long as request is not confirmed from FC-Audio, an incoming off-request
   // is not delegated to FC-Audio. It has to be confirmed manually.
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateSrcAvailableCheck_On(), u32UserData);
}

void clSrcState_RampDownToPause::vMsg_Off(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToOff(), u32UserData);
}

void clSrcState_RampDownToPause::vMsg_ServiceAvailable(clAudioSource* pclAudioSource, tU32 u32UserData)
{
   // set manually to pause because the pause-done was lost in undervoltage
   vSetState(pclAudioSource, clSrcStateFactory::pclCreateRampDownToPause(), u32UserData);
}

}

